import { Vector } from "@minecraft/server";

export const ConstantData = {
    /**
     * Spawnpoint for Players who join for the first time. Setting this to false or true will make the Player spawn in the world spawn point.
     * @type {Vector|boolean}
     */
    initialSpawnPoint: new Vector(0, 0, 0),
    /**
     * Spawnpoint for Members. Setting this to false will make the Player spawn where they last logged off. Setting this to true will make the Player spawn in the given initialSpawn.
     */
    userSpawnPoint: new Vector(0, 0, 0),
    /**
     * Spawnoint for Operators. Setting this to false will make the Player spawn where they last logged off. Setting this to true will make the Player spawn in the given initialSpawn.
     */
    adminSpawnPoint: new Vector(0, 0, 0,),
    /**
     * Permission to see script alarms. Setting this to "Operator" will only allow Operators to get script outputs. Setting this to "Member" will allow everyone to see script outputs. Setting this to "Console" will write everything in the in-game viewable logs. Setting this to "Server" will write everything in the server hidden logs. 
     * @type {string} Setting this to an invalid value will set this to "Member".
     */
    logPermission: "Operator",
    /**
     * World whitelist. If true, then only whitelisted Players set in whitelistedPlayers may be allowed to join. If false, then everyon may join.
     * @type {boolean}
     */
    whitelist: false,
    /**
     * List of whitelisted Players. Only Xbox Gamertags allowed.
     * @type {Array<string>}
     */
    whitelistedPlayers: [],
    /**
     * The length of the day-time (in minutes). Setting this to a value over 100 will set this to alwaysday = true. Negative values will lead to alwaysnight = true.
     * @type {number}
     */
    dayLength: 10,
    /**
     * The length of the night-time (in minutes). Setting this to a value over 100 will set this to alwaysnight = true. Negative values will lead to alwaysday = true.
     * @type {number}
     */
    nightLength: 10
};